<?php 
session_start();
include '../assets/constant/config.php';

try {
        $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        }
        catch(PDOException $e)
        {
        echo "Connection failed: " . $e->getMessage();
        }
?>
<?php include('include/sidebar.php'); ?>
<!-- Top Bar End -->
<?php include('include/header.php'); ?>

<!--  connect author at mdkhairnar92@gmail.com  -->




<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FullCalendar </title>
    <!-- FullCalendar CSS -->
    <link href='../fullcalendar/lib/main.css' rel='stylesheet' />
     <!-- Bootstrap CSS (for the modal) -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
   <!-- Button trigger modal -->

<button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModal">
    Add Event
</button>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Event</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form name="myform" action="app/event_crud.php" method="POST">
                    <div class="form-group col-md-6">
                        <label for="id_label_multiple">Branch<span class="text-danger">*</span> </label>
                        <select class="form-control" aria-label="Default select example" type="text" name="branch">
                            <option value="">Select branch</option>
                            <?php    
                            $sql1=$conn->prepare("select * from `branch` where delete_status='0' ");
                            $sql1->execute();
                            $row1=$sql1->fetchAll();
                            foreach ($row1 as $key1) {?>
                                <option value="<?php echo $key1['branch_name'];?> ">
                                    <?php echo $key1['branch_name'];?>
                                </option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="control-label">Event<span class="text-danger">*</span></label>
                        <input class="form-control" type="text" name="ename" />
                    </div>
                    <div class="form-group col-md-6">
                        <label class="control-label">Start date<span class="text-danger">*</span></label>
                        <input class="form-control" type="date" name="start_date" />
                    </div>
                    <div class="form-group col-md-6">
                        <label class="control-label">End date<span class="text-danger">*</span></label>
                        <input class="form-control" type="date" name="end_date" />
                    </div>
                    <div class="form-group col-md-6">
                        <label>Notes<span class="text-danger">*</span></label>
                        <textarea name="notes" class="form-control text-area-5"></textarea>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" name="submit">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
  <!-- Bootstrap JavaScript Bundle with Popper -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<div id='calendar'></div>
    <!-- FullCalendar JS -->
    <script src='../fullcalendar/lib/main.js'></script>
    <!-- PHP script for fetching events -->
    <script src='app/fetch_event.php'></script>


  <script>
    document.addEventListener('DOMContentLoaded', function() {
        var calendarEl = document.getElementById('calendar');

        var calendar = new FullCalendar.Calendar(calendarEl, {
            // Customize your calendar options here
            initialView: 'dayGridMonth',
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,timeGridDay'
            },
            events: 'app/fetch_event.php', // Correct URL to fetch events from
            eventClick: function(info) {
                 
                alert('Start: ' + info.event.start);
                alert('End: ' + info.event.end);
                // Redirect to the event detail page with the event ID
            window.location.href = 'show_event1.php?id=' + info.event.id;
            }
        });

        calendar.render();
    });
</script>
</body>
</html>



<?php include('include/footer.php'); ?>
<!--  Author Name: Mayuri K. 
 for any PHP, Codeignitor or Laravel website or software development contact me at mayuri.infospace@gmail.com  -->
